/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import slimeknights.mantle.data.GenericLoaderRegistry;

public record NestedLoader<T extends GenericLoaderRegistry.IHaveLoader<?>, N extends GenericLoaderRegistry.IHaveLoader<N>>(String typeKey, GenericLoaderRegistry<N> nestedLoader, Function<N, T> constructor, Function<T, N> getter) implements GenericLoaderRegistry.IGenericLoader<T>
{
    public static void mapType(JsonObject json, String typeKey) {
        json.addProperty("type", class_3518.method_15265((JsonObject)json, (String)typeKey));
        json.remove(typeKey);
    }

    @Override
    public T deserialize(JsonObject json) {
        NestedLoader.mapType(json, this.typeKey);
        return (T)((GenericLoaderRegistry.IHaveLoader)this.constructor.apply(this.nestedLoader.deserialize((JsonElement)json)));
    }

    public static <N extends GenericLoaderRegistry.IHaveLoader<N>> void serializeInto(JsonObject json, String typeKey, GenericLoaderRegistry<N> loader, N value) {
        JsonElement element = loader.serialize(value);
        if (element.isJsonObject()) {
            JsonObject nestedObject = element.getAsJsonObject();
            for (Map.Entry entry : nestedObject.entrySet()) {
                String key = (String)entry.getKey();
                if (typeKey.equals(key)) {
                    throw new JsonIOException("Unable to serialize nested object, object already has key " + typeKey);
                }
                if ("type".equals(key)) {
                    key = typeKey;
                }
                json.add(key, (JsonElement)entry.getValue());
            }
        } else if (element.isJsonPrimitive()) {
            json.add(typeKey, element);
        } else {
            throw new JsonIOException("Unable to serialize nested object, expected string or object");
        }
    }

    @Override
    public void serialize(T object, JsonObject json) {
        NestedLoader.serializeInto(json, this.typeKey, this.nestedLoader, (GenericLoaderRegistry.IHaveLoader)this.getter.apply(object));
    }

    @Override
    public T fromNetwork(class_2540 buffer) {
        return (T)((GenericLoaderRegistry.IHaveLoader)this.constructor.apply(this.nestedLoader.fromNetwork(buffer)));
    }

    @Override
    public void toNetwork(T object, class_2540 buffer) {
        this.nestedLoader.toNetwork((GenericLoaderRegistry.IHaveLoader)this.getter.apply(object), buffer);
    }
}

